-- Descender depth (px): how much g/j/p/q/y drop below H
function fontDescenderDepth(fName,fSize)
    local fs,A,B,wA,wB,hB,pad,gap,W,H,img,y0,xA,xB,mA,mB,d
    pushStyle()
    if fName then font(fName) end
    if fSize then fontSize(fSize) end
    fs=fSize or 18; A="H"; B="g"
    wA=textSize(A); wB,hB=textSize(B)
    pad=math.max(12,math.floor(fs*0.35)); gap=pad
    W=math.ceil(pad+wA+gap+wB+pad); H=math.ceil(pad+hB+pad)
    img=image(W,H)
    setContext(img)
    background(0,0,0,0); fill(255); noStroke()
    textMode(CORNER); textAlign(LEFT)
    y0=pad; xA=pad; xB=pad+wA+gap
    text(A,xA,y0); text(B,xB,y0)
    setContext(); popStyle()
    local function minY(x0,x1)
        for y=1,H do for x=x0,x1 do local _,_,_,a=img:get(x,y); if a>0 then return y end end end
    end
    mA=minY(math.floor(xA),math.floor(xA+wA))
    mB=minY(math.floor(xB),math.floor(xB+wB))
    d=(mA and mB) and (mA-mB) or 0
    if d<0 then d=0 end
    return d
end

_descDepthCache=_descDepthCache or {}
function drawTextIgnoringDescendersWithBottomAt(str,fSize,x,bottomY)
    local fName,key,d
    fName=(CurrentFont and CurrentFont()) or nil
    key=tostring(fName or "?").."|"..tostring(fSize)
    d=_descDepthCache[key]
    if d==nil then d=fontDescenderDepth(fName,fSize); _descDepthCache[key]=d end
    pushStyle()
    textMode(CORNER); textAlign(LEFT); fontSize(fSize); fill(20,40,60,255)
    text(str,x,bottomY-d)
    popStyle()
end