function setup()
    ----------------------------------------------------------------------------------------------
    -- Single line UITextField
    
    -- Create and configure the UITextField
    local textField = UITextField("") -- initial text
    textField._v.placeholder = "I'm a UITextField. Edit me! (This is placeholder text)"
    textField._v.font = UIFont("SourceCodePro-Medium", 16)
    -- textField._v.text -- Access current text with this value
    
    -- Callback when text changes are confirmed (user presses enter)
    textField.onEdit = function(text)
        print("Text field was edited!", text)
    end
    
    -- Add the UITextField to the root UIView
    UIView.root:addChild(textField)
    
    -- Create layout constraints used to position the UITextField.
    -- The constraints below are primarily examples to demonstrate what you can do with them.
    UIView.root:addConstraint(textField.centerX:eq(UIView.root.centerX))
    UIView.root:addConstraint(textField.width:eq(UIView.root.width * 0.8))
    UIView.root:addConstraint(textField.top:eq(UIView.root.top + 50))
    UIView.root:addConstraint(textField.height:eq(40))
    
    ----------------------------------------------------------------------------------------------
    -- Multi line UITextView
    
    -- Generate the text to display
    local displayText = "I'm an editable text view!\n\nHere is a list of all available fonts:\n"
    for i,fontName in ipairs(UIFonts) do
        displayText = displayText .. " - " .. fontName .. "\n"
    end
    
    local attrStr = objc.NSMutableAttributedString:alloc():init()
    local cursor = 0
    
    for _, fontName in ipairs(UIFonts) do
        local line = fontName .. "\n"
        local lineLen = string.len(line)
        
        -- Append the plain text line
        local nsStr = objc.NSAttributedString:alloc():initWithString_(line)
        attrStr:appendAttributedString_(nsStr)
        
        -- Apply font to just that line
        local range = objc.range(cursor, lineLen)
        local font = UIFont(fontName, 24)
        attrStr:addAttribute_value_range_("NSFont", font, range)
        
        cursor = cursor + lineLen
    end
    
    -- Create and configure the UITextView
    local textView = UITextView("")
    textView._v.attributedText = attrStr
    textView._v.editable = false
    textView._v.scrollEnabled = true
    textView._v.backgroundColor = objc.UIColor.systemGrayColor
    textView._v.textColor = objc.UIColor.greenColor
    
    -- Add it to the root view with constraints
    UIView.root:addChild(textView)
    UIView.root:addConstraint(textView.centerX:eq(UIView.root.centerX))
    UIView.root:addConstraint(textView.left:eq(UIView.root.left + 20))
    UIView.root:addConstraint(textView.right:eq(UIView.root.right - 20))
    UIView.root:addConstraint(textView.top:eq(UIView.root.top + 100))
    UIView.root:addConstraint(textView.bottom:eq(UIView.root.bottom - 20))

    local textFieldX = UITextField("Player Name")
    textFieldX._v.placeholder = "Enter name"
    textFieldX._v.font = UIFont("HelveticaNeue", 20)
    
    -- Set callback for when editing ends
    textFieldX.onEdit = function(text)
        print("Edited text:", text)
    end
    
    -- Add to root and constrain to center of screen
    UIView.root:addChild(textFieldX)
    UIView.root:addConstraint(textFieldX.centerX:eq(UIView.root.centerX))
    UIView.root:addConstraint(textFieldX.centerY:eq(UIView.root.centerY))
    UIView.root:addConstraint(textFieldX.width:eq(260))
    UIView.root:addConstraint(textFieldX.height:eq(40))

    --just for an added convenience, print out all frameworks available:
    
    -- list all included system Frameworks
    local bundles = objc.NSBundle.allFrameworks
    local systemBundles = {}
    
    for i, b in ipairs(bundles) do
        if string.find(
        b.bundlePath,
        "System/Library/Frameworks/") then
            table.insert(systemBundles, b.bundlePath)
        end
    end
    
    table.sort(systemBundles)
    
    for i, bundle in ipairs(systemBundles) do
        print(bundle)
    end
end

function draw()
    background(223, 159, 214)
end