-- Cameras

-- Use this function to perform your initial setup
function setup()
    print("Hello Cameras!")
    scene = craft.scene()
    makeSlab()
    fob = scene.camera:add(FullOrbitViewer, vec3(0,0,0), 0.1, 15, 1000)   
    fob:setPosition(vec3(10,20,-30))
    fobCam = fob.camera
    parameter.watch("fobCam:worldToScreen(vec3(0.1,0.1,0.1))")
    parameter.boolean("toggleHorizontalConstraint", false, function(v)
        if v then
            fob:setFixedAngleToHorizon(-45)
        else
            fob:setFixedAngleToHorizon(80)
        end
    end)
    parameter.boolean("toggleCurrentHorizontalConstraint", false, function()
            if not fob.fixedPitchEnabled then
                fob:setFixedAngleToHorizon()
            else
                fob:clearFixedAngleToHorizon()
            end
        end)
end

function makeSlab()
    local slab = scene:entity()
    slab.model = craft.model(asset.builtin.Primitives.RoundedCube)
    slab.scale = vec3(2, 2, 1)   
    slab.material = craft.material(asset.builtin.Materials.Basic)
    slab.material.map = readImage(asset.builtin.Surfaces.Stone_Brick_Normal)
    slab.position = vec3(0, 0, 0)
end

function update(dt)
    scene:update(dt)
end

-- This function gets called once every frame
function draw()
    update(DeltaTime)
    scene:draw()
end