viewer.mode = FULLSCREEN

function setup()
  videoPlayer = CodeaAVPlayer()
  deleteTempVideo() -- clean up any stale file from last run
end

function draw()
  background(30)
  fill(255)
  fontSize(22)
  textAlign(CENTER)
  
  if isDownloading then
    text("Downloading demo video...", WIDTH/2, HEIGHT/2 + 40)
  elseif isReady then
    text("Tap SHOWTIME to play video", WIDTH/2, HEIGHT/2 + 40)
  else
    text("Tap SHOWTIME to download + play", WIDTH/2, HEIGHT/2 + 40)
  end
  
  fontSize(60)
  text("SHOWTIME", WIDTH/2, HEIGHT/2 - 20)
end

function touched(t)
  if t.state == BEGAN then
    downloadTempVideo(function()
      videoPlayer:showAndAutoplayMOV(tempAssetKey())
    end)
    return true
  end
end

--------------- HELPERS

function willClose()
  deleteTempVideo() -- remove temp file when viewer closes
end

VIDEO_URL = "https://samplelib.com/lib/preview/mp4/sample-5s.mp4"
TEMP_VIDEO_FILE = "__avplayer_demo.mp4"

isDownloading = false
isReady = false

VIDEO_URL = "https://samplelib.com/lib/preview/mp4/sample-5s.mp4"
TEMP_VIDEO_FILE = "__avplayer_demo.mp4"

function tempAssetKey()
  return asset.documents .. TEMP_VIDEO_FILE
end

function tempVideoPath()
  return tempAssetKey().path
end

function deleteTempVideo()
  local p = tempVideoPath()
  if p then os.remove(p) end
  isReady = false
end

function downloadTempVideo(onReady)
  if isReady then onReady() return end
  if isDownloading then return end
  isDownloading = true
  
  http.request(
  VIDEO_URL,
  function(data, statusCode, headers)
    isDownloading = false
    if statusCode ~= 200 or not data then
      print("Download failed: HTTP " .. tostring(statusCode))
      return
    end
    
    local f, err = io.open(tempVideoPath(), "wb")
    if not f then
      print("Write failed: " .. tostring(err))
      return
    end
    f:write(data)
    f:close()
    
    isReady = true
    onReady()
  end,
  function(err)
    isDownloading = false
    print("Download error: " .. tostring(err))
  end
  )
end
